/*
 * I/O Subsystem definitions
 */

#ifndef _WIN32
#include <sys/poll.h>
#endif

#define FMS_IO_SIZE_INCR 1024
#define FMS_NEW_CONNECT_TIMEOUT 10000	/* allow 10 seconds for first data */

/* Channel event bits */
#define FMS_CH_READ 0x01
#define FMS_CH_WRITE 0x02

typedef struct lf_channel *lf_channel_ptr_t;
typedef void (*lf_channel_handler_t)(lf_channel_ptr_t);

/*
 * Structure describing a channel associated with a poll entry
 */
struct lf_channel {
  uint32_t poll_index;		/* index into poll_array */
  				/* (private to I/O subsystem) */

  int fd;			/* file desc for this channel */

  void *context;		/* user-defined pointer */

  void *rx_buffer;		/* place to store incoming data */
  uint32_t rx_count;		/* number of bytes desired */

  void *tx_buffer;		/* data to transmit */
  uint32_t tx_count;		/* bytes remaining to transmit */

  /* call this routine when count bytes have been received */
  lf_channel_handler_t rx_rtn;
  lf_channel_handler_t tx_rtn;
  lf_channel_handler_t hangup_rtn;
};

/*
 * prototypes
 */
int lf_init_channels(void);
int lf_add_channel(struct lf_channel *);
void lf_remove_channel(struct lf_channel *);
int lf_poll_channels(int);
void lf_channel_receive(struct lf_channel *, void *, uint32_t,
    lf_channel_handler_t);
void lf_channel_data_drain(struct lf_channel *chp);
#if 0
I think these routines are obsolete
void lf_set_channel_events(struct lf_channel *chp, int events);
void lf_reset_channel_events(struct lf_channel *chp, int events);
#endif
